﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class EdycjaOcen : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!User.IsInRole("Nauczyciel"))
            Response.Redirect("Default.aspx");
    }
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        TableCell cell=e.Row.Cells[0];
        if (cell.Text == "1")
            cell.ForeColor = System.Drawing.Color.Red;
    }
    protected void GridView1_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        int ocena, waga;
        if (int.TryParse(e.NewValues[0].ToString(), out ocena) &&
            int.TryParse(e.NewValues[1].ToString(), out waga))
            if (ocena > 0 && ocena < 7)
                if (waga > 0 && waga < 5)
                    Label1.Text = "";
                else //Warunek wagi
                {
                    Label1.Text = "Niewłaściwa waga!<br />";
                    e.Cancel = true;
                }
            else //Warunek oceny
            {
                Label1.Text = "Niewłaściwa ocena!<br />";
                e.Cancel = true;
            }
        else //TryParse
        {
            Label1.Text = "Niewłaściwe dane!<br />";
            e.Cancel = true;
        }
    }
    private void OdswierzSrednia()
    {
        DataView data = new DataView();
        data = (DataView)SqlDataSource4.Select(new DataSourceSelectArguments());
        if (data != null && data.Table.Rows.Count > 0)
        {
            double suma = 0;
            double suma2 = 0;
            double srednia = 0;
            for (int i = 0; i < data.Table.Rows.Count; i++)
            {
                suma += double.Parse(data.Table.Rows[i][1].ToString()) * 
                    double.Parse(data.Table.Rows[i][2].ToString());
                suma2 += double.Parse(data.Table.Rows[i][2].ToString());
            }
            srednia = Math.Round(suma / suma2, 2, MidpointRounding.ToEven);
            Label2.Text = " " + srednia;
            if (srednia <= 1.49)
            {
                Label3.ForeColor = System.Drawing.Color.Red;
                Label3.Text = " Niedostateczny";
            }
            else
                if ((srednia >= 1.5) && (srednia <= 2.59))
                {
                    Label3.ForeColor = System.Drawing.Color.Black;
                    Label3.Text = " Dopuszczający";
                }
                else
                    if ((srednia >= 2.6) && (srednia <= 3.59))
                    {
                        Label3.ForeColor = System.Drawing.Color.Black;
                        Label3.Text = " Dostateczny";
                    }
                    else
                        if ((srednia >= 3.6) && (srednia <= 4.59))
                        {
                            Label3.ForeColor = System.Drawing.Color.Black;
                            Label3.Text = " Dobry";
                        }
                        else
                            if ((srednia >= 4.6) && (srednia <= 5.59))
                            {
                                Label3.ForeColor = System.Drawing.Color.Black;
                                Label3.Text = " Bardzo dobry";
                            }
                            else
                            {
                                Label3.ForeColor = System.Drawing.Color.Black;
                                Label3.Text = " Celujący";
                            }
        }
        else
        {
            Label2.Text = "";
            Label3.Text = "";
        }
    }
    protected void GridView1_RowUpdated(object sender, GridViewUpdatedEventArgs e)
    {
        Label1.Text = "";
    }
    protected void GridView1_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        Label1.Text = "";
    }
    protected void GridView1_DataBound(object sender, EventArgs e)
    {
        OdswierzSrednia();
    }
    protected void DropDownList2_DataBound(object sender, EventArgs e)
    {
        GridView1.DataBind();
    }
}
